function Flagfox_handleClick(event)
{
    switch (event.button)
    {
        case 0:
            if (!event.ctrlKey)
            {
                Flagfox_handleAction("Geotool");
                return;
            } // else fallthrough; ctrl+click == middle-click
        case 1:
            Flagfox_handleAction(FFpreferences.getCharPref("flagfox.middleclick"));  // Set action via options
            return;
        // Button 2 shows popup menu via context attribute
    }
}

function Flagfox_handleCursor(imagenode)  // Changes mouseover cursor to a hand when there is a click action
{
    imagenode.style.cursor = Flagfox_isActionAllowed("Geotool") ? "pointer" : "default" ;
}

function Flagfox_handleMenu(menupopup)
{
    // Decide which menu items to grey out
    var menuItems = menupopup.getElementsByTagName("menuitem");
    for (var i=0; i < menuItems.length; i++)  // menuItems[i].value is not always reliable
        menuItems[i].setAttribute( "disabled", !Flagfox_isActionAllowed(menuItems[i].getAttribute("value")) );

    // Handle custom action
    var customMenuItem = document.getElementById("flagfox-customactionmenuitem");
    customMenuItem.hidden = !FFpreferences.getBoolPref("flagfox.customlookup.enabled");
    customMenuItem.label = Flagfox_getUCharPref(FFpreferences,"flagfox.customlookup.name");
}

function Flagfox_isActionAllowed(action)
{
    function isPrivateIP()
    {
        return flagState.country != null && flagState.country[0][0] == '-';  // -A, -B, -C, -L
    }

    switch (action)
    {
        case "Geotool":   return flagState.ip != "" && !isPrivateIP() && !flagState.IPisV6();  // Needs a non-private v4 IP
        case "Wikipedia": return flagState.country != null;                                    // Needs a fully looked-up location
        case "Whois":     return flagState.host != "" && !isPrivateIP();                       // Just needs a host, but can't be a private IP
        case "CopyIP":    return flagState.ip != "";                                           // Just needs any IP

        case "Custom":
            var customURL = Flagfox_getUCharPref(FFpreferences,"flagfox.customlookup.url");
            var needsCountry = customURL.search(/{countryName}/i)!=-1 || customURL.search(/{countryCode}/i)!=-1;
            var needsHost = customURL.search(/{domainName}/i)!=-1;
            var needsIP = customURL.search(/{IPaddress}/i)!=-1;
            if ( (needsCountry && flagState.country == null) ||
                 (needsHost && flagState.host == "") ||
                 (needsIP && flagState.ip == "") )
                return false;
            else
                return true;

        case "Options": return true;
        case "Nothing": return false;  // Set "flagfox.middleclick" to this to disable that feature

        default: return false;
    }
}

function Flagfox_handleAction(action)
{
    if (!Flagfox_isActionAllowed(action))
        return;  // Disallowed or invalid action

    switch (action)
    {
        case "Geotool":
            // Geotool figures out the locale from the HTTP header
            // We send ip and host in case Geotool resolves to a different server, based on its different location
            Flagfox_openLink("http://geotool.servehttp.com/?ip=" + flagState.ip + "&host=" + flagState.host);
            return;

        case "Wikipedia":
            var wiki;
            switch (flagState.country[0])
            {
                case '-A':  case '-B':  case '-C':
                    wiki = "RFC 1918";
                    break;
                default:  // For 'A1', 'A2', and '-L' flagState.country[1] == translated range description
                    wiki = flagState.country[1];
                    break;
            }
            Flagfox_openLink(Flagfox_getWikipediaSearchURL(wiki));
            return;

        case "Whois":
            // DomainTools can parse TLD correctly, as well as full domain names
            Flagfox_openLink("http://whois.domaintools.com/" + flagState.host);
            return;

        case "CopyIP":
            const clipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                                              .getService(Components.interfaces.nsIClipboardHelper);
            clipboardHelper.copyString(flagState.ip);
            return;

        case "Custom":
            /* Both custom URL and country name need encoding and I can't do encodeURL() for the country name
               as that ignores certain characters that might cause problems with searches. To prevent double
               encoding I do encodeURL() first and simply search using encoded placeholders.
               This is case-insensitive and placeholders may be used multiple times. */
            var customURL = encodeURI(Flagfox_getUCharPref(FFpreferences,"flagfox.customlookup.url"));
            customURL = customURL.replace(/%7BdomainName%7D/gi, flagState.host)
                                 .replace(/%7BIPaddress%7D/gi, flagState.ip);
            if (flagState.country != null)
                customURL = customURL.replace(/%7BcountryName%7D/gi, encodeURIComponent(flagState.country[1]))
                                     .replace(/%7BcountryCode%7D/gi, flagState.country[0]);
            Flagfox_openLink(customURL);
            return;

        case "Options":
            window.openDialog("chrome://flagfox/content/options.xul", "FlagfoxOptions", "chrome,dialog,centerscreen");
            return;
    }
}

function Flagfox_openLink(url)
{
    try
    {
        var tabPrefs = FFpreferences.getCharPref("flagfox.openlinksin");

        if (tabPrefs == "tabBG" || tabPrefs == "tabFG")
        {
            var newTab = window.getBrowser().addTab(url,null,null);
            if (tabPrefs == "tabFG")
                window.getBrowser().selectedTab = newTab;
        }
        else if (tabPrefs == "currentTab")
        {
            window.content.document.location = url;
        }
        else  // "winBG" || "winFG"
        {
            var newWindow = window.open(url,"_blank");
            if (tabPrefs == "winBG")
            {
                newWindow.blur();
                window.focus();
            }
        }
    } catch (e) { Flagfox_error("Failed to open URL: "+url,e); }
}
