function Flagfox_getVersion()
{
    return Components.classes["@mozilla.org/extensions/manager;1"]
                     .getService(Components.interfaces.nsIExtensionManager)
                     .getItemForID("{1018e4d6-728f-4b20-ad56-37578a4de76b}")
                     .version;
}

function Flagfox_getLocale()
{
    const prefs = Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefBranch);
    try { return prefs.getComplexValue("general.useragent.locale",Components.interfaces.nsIPrefLocalizedString).data; }
    catch (e) { return prefs.getCharPref("general.useragent.locale"); }
}

function Flagfox_getWikipediaSearchURL(search)  // Returns a Wikipedia search URL for the current locale
{
    // We do a search here, just in case the exact page doesn't exist or there is no localized version
    // The "variant" option is primarily for zh-CN and zh-TW; it is ignored if there is no variant
    const fulllocale = Flagfox_getLocale().toLowerCase();  // Strangely, Wikipedia "variant" is case-sensitive
    const baselocale = fulllocale.split('-')[0];           // language-dialect --> language
    return "http://" + baselocale + ".wikipedia.org/wiki/Special:Search?search=" + encodeURIComponent(search) + "&go=Go&variant=" + fulllocale;
}

function Flagfox_parseException(e)  // Returns a string version of an exception object with its stack trace
{
    if (!e)
        return "";
    else if (!e.stack)
        return String(e);
    else
        return String(e) + " \n" + String(e.stack);
}

function Flagfox_error(message, exception)
{
    if (!message)
        message = "Unknown error!";

    // Set "javascript.options.showInConsole" to true to view
    Components.utils.reportError("Flagfox ERROR: " + message + " \n" + Flagfox_parseException(exception));

    try
    {
        var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                                .getService(Components.interfaces.nsIXULAppInfo)
                                .QueryInterface(Components.interfaces.nsIXULRuntime);

        // No L10N: We only speak English (well) and thus our forums and the problems reported on them need to be in English. Sorry.
        var outputMsg = "Sorry, Flagfox has encountered a problem.  " +
                        "Please copy the report below and paste it on our forums with " +
                        "steps to reproduce so we can attempt to fix your issue.  (English only)\n";

        outputMsg += "\nFlagfox version " + Flagfox_getVersion() + "\n";
        outputMsg += "\nERROR MESSAGE: " + message + "\n";
        if (exception)
        {
            outputMsg += "\nEXCEPTION THROWN: " + exception + "\n";
            if (exception.stack)
                outputMsg += "\nSTACK TRACE: " + exception.stack;  // ends with "\n"
        }
        outputMsg += "\nOPTIONS: " + Flagfox_dumpPrefs() + "\n";
        outputMsg += "\nBROWSER: " + appInfo.vendor + " " + appInfo.name +  " " + appInfo.version + "/" + appInfo.appBuildID
                                   + " (Gecko " + appInfo.platformVersion + "/" + appInfo.platformBuildID + ")"
                                   + " using locale " + Flagfox_getLocale()
                                   + " on " + appInfo.OS + " " + appInfo.XPCOMABI + "\n";

        const prompts = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                  .getService(Components.interfaces.nsIPromptService);
        var flags = prompts.BUTTON_POS_0 * prompts.BUTTON_TITLE_OK +
                    prompts.BUTTON_POS_1 * prompts.BUTTON_TITLE_IS_STRING +
                    prompts.BUTTON_POS_0_DEFAULT;
        var button = prompts.confirmEx( null, "Flagfox Error!", outputMsg, flags, "", "Forums", "", null, {} );

        if (button == 1)  // "Forums" button
        {
            // Open forum in new tab (can't open new window; if error is on startup, we could hit another error)
            Flagfox_addTabInCurrentBrowser("http://flagfox.servehttp.com/forum/viewtopic.php?f=3&t=14");
        }
    }
    catch (e) { Components.utils.reportError("EXCEPTION DURING FLAGFOX ERROR REPORTING: " + Flagfox_parseException(e)); }
}

function Flagfox_addTabInCurrentBrowser(url)
{
    // Find the browser for the most recent window, regardless of where this function was called from
    const currentBrowser = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                                     .getService(Components.interfaces.nsIWindowMediator)
                                     .getMostRecentWindow("navigator:browser")
                                     .getBrowser();
    currentBrowser.selectedTab = currentBrowser.addTab(url,null,null);
}

function Flagfox_dumpPrefs()
{
    try
    {
        var branch = Components.classes["@mozilla.org/preferences-service;1"]
                               .getService(Components.interfaces.nsIPrefService)
                               .getBranch("flagfox.");
        var output = "";
        var prefList = branch.getChildList("",{});
        prefList.sort();
        for (var i in prefList)
            output += prefList[i] + "=" + Flagfox_getPref(branch,prefList[i]) + "; ";
        return (output.length ? output : "(MISSING!)");
    }
    catch (e) { return "EXCEPTION on pref dump: " + Flagfox_parseException(e); }
}

function Flagfox_getPref(prefs,prefName)
{
    switch (prefs.getPrefType(prefName))
    {
        case 0: return "(INVALID!)";                           // PREF_INVALID
        case 32: return Flagfox_getUCharPref(prefs,prefName);  // PREF_STRING
        case 64: return prefs.getIntPref(prefName);            // PREF_INT
        case 128: return prefs.getBoolPref(prefName);          // PREF_BOOL
    }
    throw "Bad pref type for: " + prefName;
}

function Flagfox_getUCharPref(prefs,prefName)  // Unicode getCharPref
{
    return prefs.getComplexValue(prefName, Components.interfaces.nsISupportsString).data;
}

function Flagfox_setUCharPref(prefs,prefName,text)  // Unicode setCharPref
{
    var string = Components.classes["@mozilla.org/supports-string;1"]
                           .createInstance(Components.interfaces.nsISupportsString);
    string.data = text;
    prefs.setComplexValue(prefName, Components.interfaces.nsISupportsString, string);
}

function Flagfox_hashString(string)  // Returns a base-64 encoded MD5 hash of a Unicode string
{
    var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"]
                              .createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
    converter.charset = "UTF-8";
    var bytes = converter.convertToByteArray(string,{});
    var cryptoHash = Components.classes["@mozilla.org/security/hash;1"]
                               .createInstance(Components.interfaces.nsICryptoHash);
    cryptoHash.init(cryptoHash.MD5);
    cryptoHash.update(bytes,bytes.length);
    return cryptoHash.finish(true);
}
