Opt('MustDeclareVars', 1)
#include <GUIConstants.au3>

;LOCAL Const $WS_CAPTION = 0x00C00000
;LOCAL Const $WS_SYSMENU = 0x00080000
;LOCAL Const $WS_EX_CLIENTEDGE = 0x00000200
;LOCAL Const $ES_LEFT = 0
;LOCAL Const $ES_AUTOHSCROLL = 128
;LOCAL Const $ES_PASSWORD = 32
;LOCAL Const $BS_DEFPUSHBUTTON	= 0x0001

; ==========================
; Hive
; ==========================
LOCAL $guiNoFixedDrives='No fixed drives are present!'
LOCAL $guiSelectWindowsDirectory='Select the remote Windows directory and then press "OK"'
LOCAL $guiLoadLocalSystemHive='Loading remote SYSTEM hive'
LOCAL $guiFailedLoadLocalSystemHive='The remote SYSTEM hive could not be loaded!'
LOCAL $guiUnloading='Unloading'
LOCAL $guiRunningWindows = 'System Hives of the current Windows session can not be loaded!'
LOCAL $guiSplashTitel = 'Loading Hive'

; ==========================
; Connect
; ==========================
LOCAL $guiConComputerNotFound='Computer not Found!', $guiConHostFieldBlank='Host field blank!', $guiConHostUnavailable='Host unavailable on the network!', $guiConUnableToAuthenticateHost='Unable to authenticate with Host!'
LOCAL $guiConLoadRemoteHive='Loading Hive of a remote Computer', $guiConSelectComputer='Select Computer', $guiConHost='Host', $guiConUserName='UserName', $guiConTTUserName='Username and Password not needed if you have Admin rights', $guiConPassword='Password', $guiConTTPassword='Username and Password not needed if you have Admin rights'
LOCAL $guiConLoad='&Load', $guiConCancel='&Cancel'
LOCAL $guiConnect, $guiConnectHost, $guiConnectUser, $guiConnectPassword, $guiConnectLoadBtn, $guiConnectCancelBtn
LOCAL $guiError='Error', $guiLoadedHive='Loaded Hive'

; ==========================
; Registry Keys
; ==========================
LOCAL CONST $hostCurrentControlSetRegKey = 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet'
LOCAL CONST $localHiveMap='_LOCAL_SYSTEM'

LOCAL $hiveParametersType=1 ; 1=running 2=local 3=remote
LOCAL $hiveParametersRegkey=$hostCurrentControlSetRegKey
LOCAL $hiveParametersMapdrv='' ; MapDrv for remote Hive
LOCAL $hiveParametersLocalDir='' ; MapDrv for remote Hive


;***************************
;Hive Management
;***************************

; ==========================
; Key from Running System
; ==========================
Func GetRunningHiveKey(ByRef $status)
; returns RegKey to CurrentControlSet
	UnloadHive()
	$status=GetStatus()
	Return $hiveParametersRegkey
EndFunc

; =============================
; Key from local Installation
; =============================
Func GetLocalHiveKey(ByRef $status)
; returns RegKey to CurrentControlSet
; error: 0=local hive selected, 1=no HDD, 2=no local hive selected, 3=running hive selected, 4=error loading local hive

	LOCAL $key, $j
	LOCAL $result
	LOCAL $hiveFile
	LOCAL $error

	$hiveFile = GetLocalHiveFile()
	If @error Then
		$error=@error
		$status=GetStatus()
		SetError($error)
		Return $hiveParametersRegkey
	Else
		UnloadHive()
		SplashTextOn ($guiSplashTitel, $guiLoadLocalSystemHive & @LF &  $hiveFile & @LF & ' as ' & 'HKEY_LOCAL_MACHINE\'& $localHiveMap & ' ...', 425, 75)
		$hiveParametersType=2
		RunWait('reg.exe LOAD HKLM\' & $localHiveMap & ' "' & $hiveFile & '"', '', @SW_HIDE)
		SplashOff()

		If @error Then	;failed to load for some reason!
			MsgBox ( 16, $guiError, $guiFailedLoadLocalSystemHive)
			GetRunningHiveKey()
			$status=GetStatus()
			SetError(4) ; error loading local hive --> load running hive
			Return $hiveParametersRegkey
		Else  ;if successfully loaded, select RegKey and reload
			$key = RegRead ('HKEY_LOCAL_MACHINE\' & $localHiveMap & '\Select\','Current')
			For $j = 1 to 3 - StringLen($key)
				$key = '0' & $key
			Next
			$hiveParametersType=2
			$hiveParametersRegkey = 'HKEY_LOCAL_MACHINE\'& $localHiveMap & '\ControlSet' & $key
			$status=GetStatus()
			Return $hiveParametersRegkey
		EndIf
	EndIf

EndFunc


Func GetLocalHiveFile()
; Return the path to the local hive file
; error: 0=local hive selected, 1=no HDD, 2=no local hive selected, 3=running hive selected
	LOCAL $hiveFile=''

	DriveGetDrive ('FIXED')
	If @error == 1 Then
		MsgBox (16, $guiError, $guiNoFixedDrives)
		SetError(1) ; no HDD
		Return $hiveFile
	Else
		;Start at 'My Computer'
		$hiveFile = FileSelectFolder($guiSelectWindowsDirectory, '::{20D04FE0-3AEA-1069-A2D8-08002B30309D}')
		If @error == 1 Then
			SetError(2) ; no local hive selected
			Return $hiveFile
		Else
			If StringUpper(EnvGet('SystemRoot')) == StringUpper($hiveFile) Then ; if hiveFile is the one from running OS, return, do nothing
				MsgBox(16, $guiError, $guiRunningWindows)
				SetError(3) ; running hive selected
				Return $hiveFile
			EndIf
			$hiveParametersLocalDir=$hiveFile
			Return $hiveFile & '\System32\config\SYSTEM'
		EndIf
	EndIf

EndFunc

; =========================
; Key from Remote Computer
; =========================
$guiConnect = GUICreate($guiConLoadRemoteHive, 417, 233, (@DesktopWidth - 417) / 2, (@DesktopHeight - 233) / 2, BitOr($WS_CAPTION, $WS_SYSMENU))
GuiSetIcon('shell32.dll', -18, $guiConnect)
GUICtrlCreateGroup($guiConSelectComputer & ' ', 24, 24, 369, 153)
GUICtrlCreateLabel($guiConHost & ' :', 56, 56)
GUICtrlCreateLabel($guiConUserName & ' :', 56, 96)
GUICtrlSetTip(-1, $guiConTTUserName)
GUICtrlCreateLabel($guiConPassword & ' :', 56, 136)
GUICtrlSetTip(-1, $guiConTTPassword)
$guiConnectHost = GUICtrlCreateInput('', 136, 56, 217, 21, -1, $WS_EX_CLIENTEDGE)
$guiConnectUser = GUICtrlCreateInput('', 136, 96, 217, 21, -1, $WS_EX_CLIENTEDGE)
$guiConnectPassword = GUICtrlCreateInput('', 136, 136, 217, 21, BitOr($ES_LEFT, $ES_AUTOHSCROLL, $ES_PASSWORD), $WS_EX_CLIENTEDGE)
$guiConnectLoadBtn = GUICtrlCreateButton($guiConLoad, 24, 192, 73, 25,$BS_DEFPUSHBUTTON)
$guiConnectCancelBtn = GUICtrlCreateButton($guiConCancel, 320, 192, 73, 25)
GuiSetState(@SW_HIDE, $guiConnect)		


Func GetRemoteHiveKey(ByRef $status)
; error: 1=Cancel
	GuiSetState(@SW_SHOW, $guiConnect)		
	While 1
		$msg = GUIGetMsg(1)

		If $msg[1] = $guiConnect Then
			Select
			Case $msg[0] = $guiConnectLoadBtn
					Local $host = GUICtrlRead($guiConnectHost)
					If StringLeft($Host, 2) == '\\' Then $host = StringMid ($host, 3)
					Local $user = GUICtrlRead($guiConnectUser)
					Local $pass = GUICtrlRead($guiConnectPassword)

					GetRemoteHive ($host, $user, $pass)
					If NOT @error Then
						GuiSetState(@SW_HIDE, $guiConnect)
						GuiCtrlSetData($guiConnectHost, '')
						GuiCtrlSetData($guiConnectUser, '')
						GuiCtrlSetData($guiConnectPassword, '')
						$status=GetStatus()
						Return $hiveParametersRegkey
					EndIf
					
			Case $msg[0] = $GUI_EVENT_CLOSE OR $msg[0] = $guiConnectCancelBtn
					GuiSetState(@SW_HIDE, $guiConnect)
					GuiCtrlSetData($guiConnectHost, '')
					GuiCtrlSetData($guiConnectUser, '')
					GuiCtrlSetData($guiConnectPassword, '')
					$status=GetStatus()
					SetError(1)
					Return $hiveParametersRegkey
			EndSelect
		EndIf
	WEnd
EndFunc


Func GetRemoteHive ($host, $user, $pass)
; error: 1=hostfield blank; 2=computer not found, 3=authentication failed

	Local $IPAddress, $tmpMapDriveLetter

	If $Host == '' Then
		MsgBox(8192 + 16, $guiError, $guiConHostFieldBlank)
		SetError(1) ; hostfield blank
		Return
	EndIf

	TCPStartup()

	$IPAddress = TCPNameToIP($host)
	If @error Then
		Msgbox(8192+16, $guiError, $guiConComputerNotFound)
		SetError(2) ; computer not found
		Return
	EndIf	
	If ping($IPAddress) < '1' Then
		MsgBox(8192 + 16, $guiError, $guiConHostUnavailable)
		SetError(2) ; computer not found
		Return
	EndIf

	If $User == '' Then
		$tmpMapDriveLetter = DriveMapAdd('*', '\\' & $Host & '\Admin$', 8)
	Else
		$tmpMapDriveLetter = DriveMapAdd('*', '\\' & $Host & '\Admin$', 8, $User, $Pass)
	EndIf

	If $tmpMapDriveLetter == '' Then
		MsgBox(8192 + 16, $guiError, $guiConUnableToAuthenticateHost)
		SetError(3) ; authentication failed
		Return
	EndIf

	UnloadHive()
	$hiveParametersType = 3
	$hiveParametersMapdrv = $tmpMapDriveLetter
	$hiveParametersRegkey = '\\' & $Host & '\' & $hostCurrentControlSetRegKey
	Return

EndFunc



; ================
; Unload the hive!
; ================

Func UnloadHive()
; error: 1=unable to unload local hive

	If $hiveParametersType = 2 Then
		SplashTextOn($guiSplashTitel, $guiUnloading & @LF & 'HKEY_LOCAL_MACHINE\' & $localHiveMap & ' ...', 400, 50)
		$hiveParametersLocalDir=''
		RunWait( 'reg.exe UNLOAD HKLM\' & $localHiveMap, '', @SW_HIDE  )
		If @error Then SetError(1)
		SplashOff()
	EndIf
	If $hiveParametersType == 3 Then
		DriveMapDel($hiveParametersMapdrv)
		$hiveParametersMapdrv=''
	EndIF
	$hiveParametersType=1
	$hiveParametersRegkey=$hostCurrentControlSetRegKey
EndFunc

; ================
; get status
; ================
Func GetStatus()
	LOCAL $status
	Select
		Case $hiveParametersType=1
			Return 'running [' & EnvGet('COMPUTERNAME') & ']'
		Case $hiveParametersType=2
			Return 'local [' & $hiveParametersLocalDir & ']'
		Case $hiveParametersType=3
			Return 'remote [' & StringUpper(StringMid($hiveParametersRegkey, 3, StringInStr($hiveParametersRegkey, '\' & $hostCurrentControlSetRegKey)-3)) & ']'
	EndSelect
	Return $status
EndFunc