; =====================================================================================
; ServicesPE 1.4korale
; Original created by Korale
; Modified by FeReNGi from version 0.6 onwards
; AutoIt v3.2.8.1
; =====================================================================================
#include <GUIConstants.au3>
#include <GuiListView.au3>
#include <HiveMngt.au3>

Opt('MustDeclareVars', 1)
Opt('GUICloseOnESC', 0)
Opt('TrayIconHide', 0)
Opt('TrayMenuMode', 1)
Opt('WinSearchChildren', 1)
Opt('WinWaitDelay', 500)

If WinExists('%_ServicesPE_GUI_%') Then Exit
AutoItWinSetTitle('%_ServicesPE_GUI_%')

;ServicesPE will not work on older systems
If @OSVersion = 'WIN_ME' Or @OSVersion = 'WIN_98' Or @OSVersion = 'WIN_95' Then
	MsgBox(16, "Error", $guiWrongOS)
	Exit
EndIf

; ==========================
; Defaults
; ==========================
DIM $logFileDir = @TempDir & '\', $logFile = 'ServicesPE.log'
DIM Const $guiTitel = 'ServicesPE 1.4korale'

; ==========================
; Registry: Service Values
; ==========================
DIM $arrType[11] = [1,1,2,4,8,16,32,272,288,333,444]
DIM $group[64] = ['AudioGroup', 'COM Infrastructure', 'Event Log', 'Base', 'Boot Bus Extender', 'Boot File System', 'Extended Base', 'File System', 'Filter', 'FSFilter Antivirus', 'FSFilter Activity Monitor', 'FSFilter Bottom', 'FSFilter Cluster File System', 'FSFilter Compression', 'FSFilter Content Screener', 'FSFilter Continuous Backup', 'FSFilter Copy Protection', 'FSFilter Encryption', 'FSFilter HSM', 'FSFilter Infrastrukture', 'FSFilter Open File', 'FSFilter Physical Quota Management', 'FSFilter Quota Management', 'FSFilter Replication', 'FSFilter Security Enhancer', 'FSFilter System', 'FSFilter System Recovery', 'FSFilter Top', 'FSFilter Undelete', 'Keyboard Class', 'Keyboard Port', 'LocalValidation', 'MS Transactions', 'NDIS', 'NDIS Wrapper', 'NetBIOSGroup', 'NetDDEGroup', 'Network', 'NetworkProvider', 'Parallel arbitrator', 'PCI Configuration', 'PlugPlay', 'PnP Filter', 'PnP_TDI', 'Pointer Class', 'Pointer Port', 'Port', 'Primary Disk', 'RemoteValidation', 'SchedulerGroup', 'SCSI CDROM Class', 'SCSI Class', 'SCSI miniport', 'ShellSvcGroup', 'SmartCardGroup', 'SpoolerGroup', 'Streams Drivers', 'System Bus Extender', 'System Reserved', 'TDI', 'UIGroup', 'Video', 'Video Init', 'Video Save']

; ==========================
; GUI
; ==========================
DIM $lvServiceList, $lvDeviceList, $lvVariableList
DIM $guiRunningOSHiveBtn, $guiMain, $guiStatus, $guiServicesBtn, $guiDevicesBtn, $guiLogBtn, $guiNewBtn, $guiDelBtn, $guiEditBtn, $guiLocalHiveBtn, $guiRemoteHiveBtn, $guiHelpBtn, $guiExitBtn
DIM $guiEdit, $guiEditNameCB, $guiEditName, $guiEditDisplNameCB, $guiEditDisplName, $guiEditStart, $guiEditType, $guiEditErrorCtrl, $guiEditPath, $guiEditCancelBtn, $guiEditPathBtn, $guiEditUpdateBtn, $guiEditPathCB, $guiEditErrorCtrlCB, $guiEditTypeCB, $guiEditStartCB, $guiEditDependOnCB, $guiEditDependOn, $guiEditDescr, $guiEditDescrCB, $guiEditGroup, $guiEditGroupCB
DIM $guiNew, $guiNewDisplName, $guiNewName, $guiNewStart, $guiNewType, $guiNewErrorCtrl, $guiNewPath, $guiNewDependOn, $guiNewDescr, $guiNewCancelBtn, $guiNewPathBtn, $guiNewInstallBtn, $guiNewGroup
DIM $guiLog, $guiLogCB, $guiLogPathBtn, $guiLogPath, $guiLogOkBtn, $guiLogCancelBtn
DIM $guiContextMenuSrv, $guiContextEditSrv, $guiContextDelSrv, $guiContextMenuDev, $guiContextEditDev, $guiContextDelDev

; ==========================
; SortFunc
; ==========================

Dim $nCurCol    = -1; Selected column
Dim $nSortDir    = 1; Sort direction
Dim $bSet    = 0; Save flag
Dim $nCol    = -1; Save column

; ==========================
; ListView
; ==========================
DIM $guiDisplayName='DisplayName', $guiServiceName='ServiceName', $guiDeviceName='DeviceName', $guiStart='Start', $guiType='Type', $guiDescription='Description', $guiGroup='Group', $guiPath='Path', $guiUser='User', $guiErrorControl='ErrorControl', $guiDependOnService='DependOnService'

; ==========================
; Type
; ==========================
DIM $guiKernelDriver='KernelDriver', $guiFileSystemDriver='FileSystemDriver', $guiAdapter='Adapter', $guiFileSystemRecognizerDriver='FileSystemRecognizerDriver' , $guiWrongType ='Wrong Type'
DIM $guiOwnProcess='OwnProcess', $guiSharedProcess='SharedProcess', $guiInteractiveOwnProcess='InteractiveOwnProcess', $guiInteractiveSharedProcess='InteractiveSharedProcess'
DIM $guiDevice='Device', $guiService='Service'

; ==========================
; Start
; ==========================
DIM $guiBoot='Boot', $guiSystem='System', $guiAutomatic='Automatic', $guiManual='Manual', $guiDisable='Disable', $guiWrongStart='Wrong'

; ==========================
; Menu
; ==========================
DIM $guiMenuItLoadRunning, $guiMenuService, $guiMenuDisplay, $guiMenuHelp, $guiMenuItSupport, $guiMenuItLoadLocal, $guiMenuItLoadRemote, $guiMenuItNew, $guiMenuItEdit,$guiMenuItDelete, $guiMenuItExit, $guiMenuITService, $guiMenuITDevice, $guiMenuITStatusLine, $guiMenuItInfo

DIM $guiMenuTTDisplay='&View', $guiMenuTTServices='&Services'
DIM $guiMenuItemLoadRunningHive='Select running OS', $guiMenuItemHelp='Help'
DIM $guiMenuItemServices='Services', $guiMenuItemDevices='Devices', $guiMenuItemStatusLine='Status Line'
DIM $guiMenuItemLoadLocalHive='Select local Hive', $guiMenuItemLoadRemote='Select remote System',$guiMenuItemNew='New', $guiMenuItemEdit='Edit', $guiMenuItemDelete='Delete', $guiMenuItemExit='Exit'

; ==========================
; ErrorControl
; ==========================
DIM $guiIgnore='Ignore - Ignore error & continue', $guiNormal='Normal - Log error & continue', $guiHigh='High - Log error & restart', $guiCritical='Critical - Log error & fail boot', $guiWrongErrorControl = 'Wrong ErrorContol'

; ==========================
; Misc
; ==========================
DIM $cmd[3]
DIM $msg, $i
DIM $guiOK='OK', $guiCancel='Cancel', $guiUpdate='Update', $guiInstall='Install'
DIM $guiError='Error', $guiEdit='Edit', $guiDelete='Delete'
DIM $status, $basekey=GetRunningHiveKey($status)

DIM $guiEditOptions='Edit Options', $guiNewService='New Service/Device', $guiLogOptions='Log Options'

DIM $guiServiceExists1='The Service/Device with the name', $guiServiceExists2='already exists'
DIM $guiDeleteService='Delete Service/Device', $guiWantToDeleteService='Do you really want to delete the Service'
DIM $guiUpdateParameter='Update Parameter', $guiWantToUpdateParameter='Do you really want to update parameters for the Service', $guiSelectService='Select Service'
DIM $guiInstallService='Install Service/Device', $guiWantToInstallService1='Do you really want to install', $guiWantToInstallService2='as new Service/Device', $guiFillOut='Please fill out the fields', $guiNoFileChosen='No File chosen'
DIM $guiSelectLogfilePath='Select Logfile Path', $guiNoFolderChosen='No Folder chosen'

DIM $guiWrongOS='ServicesPE will not run on this operating system', $guiSelectServiceFirst='Please select the Service/Device first!'

; ==========================
; Tooltips
; ==========================
DIM $guiTTRunningOSHiveBtn = 'Select running Operating System', $guiTTServicesBtn = 'List Services', $guiTTDevicesBtn = 'List Devices', $guiTTLogBtn = 'Log Options', $guiTTNewBtn = 'New Service/Device', $guiTTDelBtn = 'Delete Service/Device', $guiTTEditBtn = 'Edit Options', $guiTTLocalHiveBtn = 'Select a local Hive', $guiTTRemoteHiveBtn = 'Select a remote System', $guiTTHelpBtn = 'Help', $guiTTExitBtn = 'Exit Program'
DIM $guiTTServicePEinit1='ServicesPE is initializing', $guiTTServicePEinit2='ServicesPE will be fully operational in few seconds', $guiTTShowServicesPE='Show ServicesPE Window', $guiTTExitServicesPE='Exit ServicesPE'

; ==========================
; Help
; ==========================
DIM $guiHelpTitle='Help'
DIM $guiHelpDescription = 'This programs allows you to change the service properties of a local or a remote computer'
DIM $guiHelpProgrammer = 'Original source provided by korale and modified by FeReNGi'

DIM $language='English', $author = 'korale and FeReNGi'


; ==========================
; Registry: Service Values
; ==========================
DIM $type[3][10] = [[1,2,4,8,16,32,272,288,333,444], [$guiKernelDriver, $guiFileSystemDriver, $guiAdapter, $guiFileSystemRecognizerDriver, $guiOwnProcess, $guiSharedProcess, $guiInteractiveOwnProcess, $guiInteractiveSharedProcess, $guiWrongType, ''], [$guiDevice, $guiDevice, $guiDevice, $guiDevice, $guiService, $guiService, $guiService, $guiService, $guiDevice,$guiDevice]]
DIM $start[7] = [$guiBoot, $guiSystem, $guiAutomatic, $guiManual, $guiDisable, $guiWrongStart, '']
DIM $errorCtrl[6] = [$guiIgnore, $guiNormal, $guiHigh, $guiCritical, $guiWrongErrorControl, '']


; =========================
; TrayToolTip
; =========================
DIM $TrayShow, $TrayExit, $TrayMSG

TrayTip($guiTTServicePEinit1, $guiTTServicePEinit2, 2, 1)
TraySetToolTip ('ServicesPE')
$TrayShow = TrayCreateItem ($guiTTShowServicesPE)
$TrayExit = TrayCreateItem ($guiTTExitServicesPE)


; ********************************
; Main
; ********************************

; =========================
; GUI - Formatting
; =========================
$guiMain = GUICreate($guiTitel, 640, 438, (@DesktopWidth - 640) / 2, (@DesktopHeight - 438) / 2, BitOr($GUI_SS_DEFAULT_GUI, $WS_SIZEBOX, $WS_MAXIMIZEBOX,$WS_MINIMIZEBOX))

; =========================
; GUI - ListView Services
; =========================
$lvServiceList = GUICtrlCreateListView($guiDisplayName & '|' & $guiServiceName & '|' & $guiStart & '|' & $guiType & '|' & $guiDescription & '|' & $guiGroup & '|' & $guiPath & '|' & $guiUser & '|' & $guiErrorControl & '|' & $guiDependOnService, 0, 40, 640, 360, BitOr($LVS_ICON, $LVS_SHOWSELALWAYS, $LVS_SINGLESEL))
GUICtrlSetResizing (-1,BitOr($GUI_DOCKTOP, $GUI_DOCKBOTTOM))
GUICtrlRegisterListViewSort(-1, "LVSort")
GUICtrlCreateListViewItem('00000000000000000000|1111111111|2222222222|333333333333333|444444444444444|5555555555|666666666666666|777777777777777|88888|9999999999', $lvServiceList)

; =========================
; GUI - ListView Devices
; =========================
$lvDeviceList = GUICtrlCreateListView($guiDisplayName & '|' & $guiDeviceName & '|' & $guiStart & '|' & $guiType & '|' & $guiDescription & '|' & $guiGroup & '|' & $guiPath & '|' & $guiUser & '|' & $guiErrorControl & '|' & $guiDependOnService, 0, 40, 640, 360,BitOr($LVS_ICON, $LVS_SHOWSELALWAYS, $LVS_SINGLESEL))
GUICtrlSetResizing (-1,BitOr($GUI_DOCKTOP, $GUI_DOCKBOTTOM))
GUICtrlRegisterListViewSort(-1, "LVSort")
GUICtrlSetState ($lvDeviceList, $GUI_HIDE + $GUI_DISABLE)
GUICtrlCreateListViewItem('00000000000000000000|1111111111|2222222222|333333333333333|444444444444444|5555555555|666666666666666|777777777777777|88888|9999999999', $lvDeviceList)

; ===========================
; GUI - ContextMenu Services
; ===========================
$guiContextMenuSrv = GUICtrlCreateContextMenu($lvServiceList)
$guiContextEditSrv = GUICtrlCreateMenuItem($guiEdit, $guiContextMenuSrv)
$guiContextDelSrv  = GUICtrlCreateMenuItem($guiDelete, $guiContextMenuSrv)

; ===========================
; GUI - ContextMenu Devices
; ===========================
$guiContextMenuDev = GUICtrlCreateContextMenu($lvDeviceList)
$guiContextEditDev = GUICtrlCreateMenuItem($guiEdit, $guiContextMenuDev)
$guiContextDelDev  = GUICtrlCreateMenuItem($guiDelete, $guiContextMenuDev)

; ===============================
; GUI - Menu
; ===============================
$guiMenuService = GUICtrlCreateMenu ($guiMenuTTServices)
$guiMenuItLoadRunning = GUICtrlCreateMenuitem ($guiMenuItemLoadRunningHive,$guiMenuService)
$guiMenuItLoadLocal = GUICtrlCreateMenuitem ($guiMenuItemLoadLocalHive,$guiMenuService)
$guiMenuItLoadRemote = GUICtrlCreateMenuitem ($guiMenuItemLoadRemote,$guiMenuService)
GUICtrlCreateMenuitem ('',$guiMenuService)
$guiMenuItNew = GUICtrlCreateMenuitem ($guiMenuItemNew,$guiMenuService)
$guiMenuItEdit = GUICtrlCreateMenuitem ($guiMenuItemEdit,$guiMenuService)
$guiMenuItDelete = GUICtrlCreateMenuitem ($guiMenuItemDelete,$guiMenuService)
GUICtrlCreateMenuitem ('',$guiMenuService)
$guiMenuItExit = GUICtrlCreateMenuitem ($guiMenuItemExit,$guiMenuService)

$guiMenuDisplay = GUICtrlCreateMenu ($guiMenuTTDisplay)
$guiMenuITService = GUICtrlCreateMenuitem ($guiMenuItemServices,$guiMenuDisplay)
GUICtrlSetState(-1,$GUI_CHECKED)
$guiMenuITDevice= GUICtrlCreateMenuitem ($guiMenuItemDevices,$guiMenuDisplay)
GUICtrlCreateMenuitem ('',$guiMenuDisplay)
$guiMenuITStatusLine= GUICtrlCreateMenuitem ($guiMenuItemStatusLine,$guiMenuDisplay)
GUICtrlSetState(-1,$GUI_CHECKED)

$guiMenuHelp = GUICtrlCreateMenu ('?')
$guiMenuItInfo = GUICtrlCreateMenuitem ($guiMenuItemHelp,$guiMenuHelp)
$guiMenuItSupport = GUICtrlCreateMenuitem ("911 CD Forum",$guiMenuHelp)

; ===============================
; GUI - ButtonMenu
; ===============================
$guiServicesBtn = GUICtrlCreateButton ('ServicesBtn', 0,0,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTServicesBtn)
GuiCtrlSetImage(-1,'ServicesPE.exe', 0)
$guiDevicesBtn = GUICtrlCreateButton ('DevicesBtn', 40,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTDevicesBtn)
GUICtrlSetImage (-1, 'newdev.dll', 0)
$guiNewBtn = GUICtrlCreateButton ('NewBtn', 120,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTNewBtn)
GUICtrlSetImage (-1, 'shell32.dll', -73)
$guiEditBtn = GUICtrlCreateButton ('EditBtn', 160,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTEditBtn)
GUICtrlSetImage (-1, 'shell32.dll', -58)
$guiDelBtn = GUICtrlCreateButton ('DelBtn', 200,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTDelBtn)
GUICtrlSetImage (-1, 'shell32.dll', -132)
$guiLogBtn = GUICtrlCreateButton ('LogBtn', 280,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTLogBtn)
GUICtrlSetImage (-1, 'shell32.dll', -70)

$guiRunningOSHiveBtn = GUICtrlCreateButton ('LocalHiveBtn', 320,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTRunningOSHiveBtn)
GUICtrlSetImage (-1, 'shell32.dll', -91)
$guiLocalHiveBtn = GUICtrlCreateButton ('RunningHiveBtn', 360,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTLocalHiveBtn)
GUICtrlSetImage (-1, 'shell32.dll', -69)
$guiRemoteHiveBtn = GUICtrlCreateButton ('ConnectBtn', 400,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTRemoteHiveBtn)
GUICtrlSetImage (-1, 'shell32.dll', -18)
$guiHelpBtn = GUICtrlCreateButton ('HelpBtn', 480,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTHelpBtn)
GUICtrlSetImage (-1, 'shell32.dll', -155)
$guiExitBtn = GUICtrlCreateButton ('ExitBtn', 520,00,40,40,$BS_ICON)
GUICtrlSetResizing (-1,$GUI_DOCKALL)
GUICtrlSetTip(-1, $guiTTExitBtn)
GUICtrlSetImage (-1, 'shell32.dll', -28)

; ===============================
; Statusline
; ===============================
$guiStatus = GUICtrlCreateLabel(' ' & $status, 0, 402, 640, 17, BitOr($SS_SIMPLE,$SS_SUNKEN))
GUICtrlSetResizing (-1,BitOr($GUI_DOCKBOTTOM, $GUI_DOCKHEIGHT))

$lvVariableList = SetList($lvServiceList) ; Shows List of Services

; ===============================
; Show Window
; ===============================

GetLists() ; Loads Service & Device List from Registry

GUISwitch($guiMain)
GUISetState(@SW_SHOW) ; Show main window
Traytip('','',0)
WinActivate($guiTitel)

; ========================================
; GUI - Edit Options
; ========================================
$guiEdit = GuiCreate($guiEditOptions, 470, 325, (@DesktopWidth - 470) / 2, (@DesktopHeight - 325) / 2, BitOr($WS_CAPTION, $WS_SYSMENU), -1, $guiMain)
GuiSetIcon('shell32.dll', -58, $guiEdit)

$guiEditNameCB = GUICtrlCreateCheckbox ($guiServiceName  & ': ', 20, 12)
$guiEditName = GUICtrlCreateInput ( '', 140, 10, 310, 20, $ES_READONLY)

$guiEditDisplNameCB = GUICtrlCreateCheckbox ($guiDisplayName & ': ', 20, 52)
$guiEditDisplName = GUICtrlCreateInput ( '', 140, 50, 310, 20)

$guiEditPathCB = GUICtrlCreateCheckbox ('', 20, 80, 20, 20) 
$guiEditPathBtn = GUICtrlCreateButton ( $guiPath, 40, 80, 60, 20, $BS_FLAT)
$guiEditPath = GUICtrlCreateInput ( '', 140, 80, 310, 20)

$guiEditDependOnCB = GUICtrlCreateCheckbox ($guiDependOnService & ': ', 20, 112) 
$guiEditDependOn = GUICtrlCreateInput ( '', 140, 112, 310, 20)

$guiEditDescrCB = GUICtrlCreateCheckbox ($guiDescription & ': ', 20, 142) 
$guiEditDescr = GUICtrlCreateInput ( '', 140, 140, 310, 50, BitOr($ES_MULTILINE, $ES_LEFT, $ES_AUTOVSCROLL))

$guiEditStartCB = GUICtrlCreateCheckbox ($guiStart & ': ', 20, 202) 
$guiEditStart = GUICtrlCreateCombo ($start[0], 140, 200, 200, 20)
$msg = ''
For $i = 1 To UBound($start) - 3
	$msg = $msg & $start[$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiEditStart, $msg) 

$guiEditTypeCB = GUICtrlCreateCheckbox ($guiType & ': ', 20, 232) 
$guiEditType = GUICtrlCreateCombo ($type[1][0], 140, 230, 200, 20)
$msg = ''
For $i = 1 To UBound($arrType) - 4
	$msg = $msg & $type[1][$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiEditType, $msg) 

$guiEditErrorCtrlCB = GUICtrlCreateCheckbox ($guiErrorControl & ': ', 20, 262) 
$guiEditErrorCtrl = GUICtrlCreateCombo ($errorCtrl[0], 140, 260, 200, 20)
$msg = ''
For $i = 1 To UBound($errorCtrl) - 3
	$msg = $msg & $errorCtrl[$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiEditErrorCtrl, $msg) 

$guiEditGroupCB = GUICtrlCreateCheckbox ($guiGroup & ': ', 20, 292) 
$guiEditGroup = GUICtrlCreateCombo (' ', 140, 290, 200, 20)
$msg = ''
For $i = 0 To UBound($group) - 1
	$msg = $msg & $group[$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiEditGroup, $msg) 

$guiEditUpdateBtn = GUICtrlCreateButton($guiUpdate, 350, 242, 100, 30)
$guiEditCancelBtn = GUICtrlCreateButton($guiCancel, 350, 282, 100, 30)

; ========================================
; GUI - New
; ========================================
$guiNew = GuiCreate($guiNewService, 470, 315, (@DesktopWidth - 470) / 2, (@DesktopHeight - 315) / 2, BitOr($WS_CAPTION, $WS_SYSMENU), -1, $guiMain)
GuiSetIcon('shell32.dll', -73, $guiNew)

GUICtrlCreateLabel ($guiServiceName & ': ', 20, 12) 
$guiNewName = GUICtrlCreateInput ( '', 140, 10, 310, 20)

GUICtrlCreateLabel ($guiDisplayName & ': ', 20, 42)
$guiNewDisplName = GUICtrlCreateInput ( '', 140, 40, 310, 20)

$guiNewPathBtn = GUICtrlCreateButton ($guiPath, 20, 72, 50, 20, $BS_FLAT)
$guiNewPath = GUICtrlCreateInput ( '', 140, 70, 310, 20)

GUICtrlCreateLabel ($guiDependOnService & ': ', 20, 102) 
$guiNewDependOn = GUICtrlCreateInput ( '', 140, 102, 310, 20)

GUICtrlCreateLabel ($guiDescription & ': ', 20, 132) 
$guiNewDescr = GUICtrlCreateInput ( '', 140, 130, 310, 50, BitOr($ES_MULTILINE, $ES_LEFT, $ES_AUTOVSCROLL))

GUICtrlCreateLabel ($guiStart & ': ', 20, 192) 
$guiNewStart = GUICtrlCreateCombo ($start[0], 140, 190, 200, 20)
$msg = ''
For $i = 1 To UBound($start) - 3
	$msg = $msg & $start[$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiNewStart, $msg) 

GUICtrlCreateLabel ($guiType & ': ', 20, 222) 
$guiNewType = GUICtrlCreateCombo ($type[1][0], 140, 220, 200, 20)
$msg = ''
For $i = 1 To UBound($arrType) - 4
	$msg = $msg & $type[1][$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiNewType, $msg) 

GUICtrlCreateLabel ($guiErrorControl & ': ', 20, 252) 
$guiNewErrorCtrl = GUICtrlCreateCombo ($errorCtrl[0], 140, 250, 200, 20)
$msg = ''
For $i = 1 To UBound($errorCtrl) - 3
	$msg = $msg & $errorCtrl[$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiNewErrorCtrl, $msg) 

GUICtrlCreateLabel ($guiGroup & ': ', 20, 282) 
$guiNewGroup = GUICtrlCreateCombo (' ', 140, 280, 200, 20)
$msg = ''
For $i = 0 To UBound($group) - 1
	$msg = $msg & $group[$i] & '|'
Next
$msg = StringTrimRight ($msg, 1)
GUICtrlSetData($guiNewGroup, $msg) 

$guiNewInstallBtn = GUICtrlCreateButton($guiInstall, 350, 232, 100, 30)
$guiNewCancelBtn = GUICtrlCreateButton($guiCancel, 350, 272, 100, 30)

; ========================================
; GUI - Log
; ========================================
$guiLog = GuiCreate($guiLogOptions, 400, 90, (@DesktopWidth - 400) / 2, (@DesktopHeight - 90) / 2, BitOr($WS_CAPTION, $WS_SYSMENU), -1, $guiMain)
GuiSetIcon('shell32.dll', -70, $guiLog)

$guiLogCB = GUICtrlCreateCheckbox ('', 20, 20, 20, 20) 
$guiLogPathBtn = GUICtrlCreateButton ($guiPath, 40, 20, 60, 20, $BS_FLAT)
$guiLogPath = GUICtrlCreateInput ($logFileDir & $logFile, 110, 20, 270, 20)

$guiLogOkBtn = GUICtrlCreateButton ($guiOk, 20, 50, 70, 25)
$guiLogCancelBtn = GUICtrlCreateButton ($guiCancel, 100, 50, 70, 25)

; ==========================
; Start TCP/IP
; ==========================

TCPStartup()

; ==========================
; Main - Loop
; ==========================

While 1
	$msg = GUIGetMsg(1)
	$TrayMSG = TrayGetMsg()
	If $TrayMSG=$TrayShow Then WinActivate($guiTitel)
	If $TrayMSG=$TrayExit Then Exit		
	If $msg[1] = $guiMain Then	; Main
		Select
			Case $msg[0] = $GUI_EVENT_CLOSE OR $msg[0] = $guiExitBtn OR $msg[0] = $guiMenuItExit OR $TrayMSG=$TrayExit
				ExitLoop

			Case $msg[0] = $guiServicesBtn OR $msg[0] = $guiMenuITService
				$lvVariableList = SetList($lvServiceList)

			Case $msg[0] = $guiDevicesBtn OR $msg[0] = $guiMenuITDevice
				$lvVariableList = SetList($lvDeviceList)

			Case $msg[0] = $guiLogBtn
				EvtShowLog()

			Case $msg[0] = $lvVariableList
				EvtSort($lvVariableList)

			Case $msg[0] = $guiNewBtn OR $msg[0] = $guiMenuItNew
				EvtShowNew()

			Case $msg[0] = $guiEditBtn OR $msg[0] = $guiMenuItEdit OR $msg[0] = $guiContextEditSrv OR $msg[0] = $guiContextEditDev
				If GUICtrlRead($lvVariableList) > 0 Then 
					EvtShowEdit($lvVariableList, _GUICtrlListViewGetCurSel($lvVariableList))
				Else
					MsgBox(8192 + 16,$guiError, $guiSelectServiceFirst)
				EndIf							

			Case $msg[0] = $guiDelBtn OR $msg[0] = $guiMenuItDelete OR $msg[0] = $guiContextDelSrv OR $msg[0] = $guiContextDelDev
				If GUICtrlRead($lvVariableList) > 0 Then	
					EvtDelete($lvVariableList)
				Else
					MsgBox(8192 + 16,$guiError,$guiSelectServiceFirst)
				EndIf

			Case $msg[0] = $guiLocalHiveBtn OR $msg[0] = $guiMenuItLoadLocal
				MainDeactivate()
				$basekey=GetLocalHiveKey($status)
				If NOT @error Then
					GetLists()
					GuiCtrlSetData($guiStatus,' ' & $status)
				EndIf
				MainActivate()

			Case $msg[0] = $guiRunningOSHiveBtn or $msg[0] = $guiMenuItLoadRunning
				MainDeactivate()
				If MsgBox(36, 'Load running Hive', 'Do you want to load the Hive from running System?') == 6 Then
					$basekey=GetRunningHiveKey($status)
					GuiCtrlSetData($guiStatus,' ' & $status)
				EndIf

				MainActivate()

			Case $msg[0] = $guiRemoteHiveBtn OR $msg[0] = $guiMenuItLoadRemote
				MainDeactivate()
				$basekey=GetRemoteHiveKey($status)
				If NOT @error Then
					GetLists()
					GuiCtrlSetData($guiStatus,' ' & $status)
				EndIf
				MainActivate()

			Case $msg[0] = $guiHelpBtn OR $msg[0] = $guiMenuItInfo
				EvtHelp()	

			Case $msg[0] = $guiMenuItSupport
				Run(@ComSpec & ' /C start http://www.911cd.net/forums//index.php?showtopic=12974', '', @SW_HIDE)

			Case $msg[0] = $guiMenuITStatusLine
				LOCAL $size = WinGetPos('')
				If BitAnd(GUICtrlRead($guiMenuITStatusLine),$GUI_CHECKED) = $GUI_CHECKED Then
					GUICtrlSetState($guiMenuITStatusLine,$GUI_UNCHECKED)
					GUICtrlSetState($guiStatus,$GUI_HIDE)

					GUICtrlSetPos($lvServiceList,0, 40, $size[2]-8,  $size[3]-86)
					GUICtrlSetPos($lvDeviceList,0, 40, $size[2]-8,  $size[3]-86)

				Else
					GUICtrlSetState($guiMenuITStatusLine,$GUI_CHECKED)
					GUICtrlSetState($guiStatus,$GUI_SHOW)

					GUICtrlSetPos($lvServiceList,0, 40, $size[2]-8,  $size[3]-105)
					GUICtrlSetPos($lvDeviceList,0, 40, $size[2]-8,  $size[3]-105)
				EndIf

		EndSelect
	EndIf
WEnd
Exit

; **************************
; Functions
; **************************
; ==========================
; GetLists from Registry
; ==========================
Func GetLists()
	LOCAL $regKey, $tmpRegKey, $i, $j, $lvItem
	LOCAL $type1, $type2, $displayName, $description, $startType, $dependOnService, $errorcontrolType, $imagePath, $objectName, $groupType
	$j = 1

	;only for the layout of the columns - defines the width

	_GUICtrlListViewDeleteAllItems($lvServiceList)
	_GUICtrlListViewDeleteAllItems($lvDeviceList)

	_ReduceMemory()
	Do
		$tmpRegKey = RegEnumKey($basekey & '\Services\', $j)
		If @error or ($tmpRegKey == '') Then ExitLoop

		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'Type')
		$i = _ArrayBinarySearch ($arrType, $regKey, 1) - 1
		If @error == 0 Then
			$type1 = $type[1][$i]
			$type2 = $i

		ElseIf @error == 3 Then ;##### wrong Type in Reg
			$type1 = $type[1][8]
			$type2 = 8
		Else
			$type1 = $type[1][9]
			$type2 = 9
		EndIf


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'DisplayName')
		If @error Then $regKey = $tmpRegKey ;If there's an error reading 'DisplayName' use the KeyName
		$displayName = $regKey


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'Description')
		$description = $regKey


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'Start')
		If ($regKey < 5) AND (@error == 0) Then
		$startType = $start[$regKey]
		ElseIf @error Then
			$startType = $start[6]    ;##### No Starttype in Reg
		Else
			$startType = $start[5]    ;##### wrong Starttype in Reg

		EndIf


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'DependOnService')
		$dependOnService = StringReplace($regKey, @LF, ', ')


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'ErrorControl')
		If ($regKey < 4) AND (@error == 0) Then
			$errorcontrolType = $errorCtrl[$regKey]
		ElseIf @error Then
			$errorcontrolType = $errorCtrl[5]         ;###### No ErrorControlType
		Else
			$errorcontrolType = $errorCtrl[4]         ;###### wrong ErrorControlType
		EndIf


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'ImagePath')
		$imagePath = $regKey


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'ObjectName')
		$objectName = $regKey


		$regKey = RegRead ( $basekey & '\Services\' & $tmpRegKey, 'Group')
		$groupType = $regKey
		Select
			Case $type[2][$type2]=$guiService
				$lvItem = GUICtrlCreateListViewItem(' |||||||||', $lvServiceList)
				GuiCtrlSetImage($lvItem, 'ServicesPE.exe', 0) 
				
			Case $type[2][$type2]=$guiDevice
				$lvItem = GUICtrlCreateListViewItem(' |||||||||', $lvDeviceList)
				GUICtrlSetImage ($lvItem, 'newdev.dll', 0, 1)

		EndSelect
		GUICtrlSetData ($lvItem, $displayName & '|' & $tmpRegKey & '|' & $startType & '|' & $type1 & '|' & $description & '|' & $groupType & '|' & $imagePath & '|' & $objectName & '|' & $errorcontrolType & '|' & $dependOnService)
;		If ($startType == $start[5]) OR ($errorcontrolType == $errorCtrl[4]) OR ($type2 == 8) Then
;			GUICtrlSetBkColor (-1, 0xff0000)
;		EndIf
		$j = $j + 1
	Until 0
EndFunc

; ******************
; Eventhandling
; ******************
; ================
; Main
; ================
Func EvtShowEdit(ByRef $listview, $pos) ; Show Options dialog
	MainDeactivate()
	UpdUnchk()

	GUICtrlSetData ($guiEditName, _GUICtrlListViewGetItemText($listview, $pos, 1))
	GUICtrlSetData ($guiEditDisplName, RegRead($basekey & '\Services\' & _GUICtrlListViewGetItemText($listview, $pos, 1), 'DisplayName'))
	GUICtrlSetData ($guiEditPath, _GUICtrlListViewGetItemText($listview, $pos, 6))
	GUICtrlSetData ($guiEditDependOn, _GUICtrlListViewGetItemText($listview, $pos, 9))
	GUICtrlSetData ($guiEditDescr, _GUICtrlListViewGetItemText($listview, $pos, 4))
	_GUICtrlComboSelectString($guiEditStart, 0, _GUICtrlListViewGetItemText($listview, $pos, 2))
	_GUICtrlComboSelectString($guiEditType, 0, _GUICtrlListViewGetItemText($listview, $pos, 3))
	_GUICtrlComboSelectString($guiEditErrorCtrl, 0, _GUICtrlListViewGetItemText($listview, $pos, 8))
	_GUICtrlComboSelectString($guiEditGroup, 0, _GUICtrlListViewGetItemText($listview, $pos, 5))
	If _GUICtrlListViewGetItemText($listview, $pos, 5) == '' Then _GUICtrlComboSetCurSel($guiEditGroup, 0)

	GuiSetState(@SW_SHOW, $guiEdit)

	_ReduceMemory()
	While 1
		$msg = GUIGetMsg(1)

		If $msg[1] = $guiEdit Then	; Edit Options

			Select
				Case $msg[0] = $guiEditUpdateBtn
					If EvtEditUpdate($listview, $pos) = 1 Then
						ExitLoop			
					Endif

				Case $msg[0] = $guiEditPathBtn
					EvtEditPath()

				Case $msg[0] = $guiEditCancelBtn
					ExitLoop

				Case $msg[0] = $GUI_EVENT_CLOSE
					ExitLoop
			EndSelect
		EndIf
	WEnd

	GuiSetState(@SW_HIDE, $guiEdit)
	MainActivate()
EndFunc

Func EvtShowLog() ; Show LogFile Parameters
	MainDeactivate()
	GuiSetState(@SW_SHOW, $guiLog)

	_ReduceMemory()
	While 1
		$msg = GUIGetMsg(1)

		If $msg[1] = $guiLog Then	; Log Options
			Select
				Case $msg[0] = $guiLogPathBtn
					EvtLogPath()

				Case $msg[0] = $guiLogOkBtn
					EvtLogOk()
					ExitLoop

				Case $msg[0] = $GUI_EVENT_CLOSE OR $msg[0] = $guiLogCancelBtn
					ExitLoop

			EndSelect
		EndIf
	WEnd

	GuiSetState(@SW_HIDE, $guiLog)
	MainActivate()
EndFunc

Func EvtShowNew() ; Show New Service/Device Dialog
	MainDeactivate()

	GUICtrlSetData($guiNewDisplName, '')
	GUICtrlSetData($guiNewName, '')
	GUICtrlSetData($guiNewPath, '')
	GUICtrlSetData($guiNewDependOn, '')
	GUICtrlSetData($guiNewDescr, '')
	_GUICtrlComboSetCurSel($guiNewStart, 0)
	_GUICtrlComboSetCurSel($guiNewErrorCtrl, 0)
	_GUICtrlComboSetCurSel($guiNewType, 0)
	_GUICtrlComboSetCurSel($guiNewGroup, 0)

	GuiSetState(@SW_SHOW, $guiNew)

	_ReduceMemory()
	While 1
		$msg = GUIGetMsg(1)

		If $msg[1] = $guiNew Then	; Log Options

			Select
				Case $msg[0] = $guiNewInstallBtn
					If EvtNewInstSrv() = 1 Then ExitLoop

				Case $msg[0] = $guiNewPathBtn
					EvtNewPath()

				Case $msg[0] = $GUI_EVENT_CLOSE OR $msg[0] = $guiNewCancelBtn
					ExitLoop
			EndSelect
		EndIf
	WEnd

	GuiSetState(@SW_HIDE, $guiNew)
	MainActivate()
EndFunc

Func EvtDelete(ByRef $listview)
	Local $pos, $displName, $name, $file, $string = ''

;	MainDeactivate()
	$pos = _GUICtrlListViewGetCurSel($listview)
	$displName = _GUICtrlListViewGetItemText($listview, $pos, 0)
	$name = _GUICtrlListViewGetItemText($listview, $pos, 1)

	If MsgBox(8192 + 36, $guiDeleteService, $guiWantToDeleteService & ': ' &  @LF &  @LF & $displName  & ' ' & '(' & $name & ')') == 6 Then
		If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then
			FileWrite($logFileDir & $logFile, '----- Delete -----' & @LF & 'Key: ' & $basekey & '\Services\' &  $name & @LF & @LF)
			RunWait ('reg.exe EXPORT ' & $basekey & '\Services\' & $name & ' ' & $logFileDir & 'ServicesPE.tmp', '' , @SW_HIDE)
			$file = FileOpen ($logFileDir & 'ServicesPE.tmp', 0)
			_ReduceMemory()
			Do
				$string = $string & FileRead($file, 1)
			Until @error = -1
			FileClose($file)
			FileWrite($logFileDir & $logFile, $string)
			FileDelete($logFileDir & 'ServicesPE.tmp')
			FileWrite($logFileDir & $logFile, '--- Delete End ---' & @LF & @LF)
		EndIf
		RegDelete($basekey & '\Services\' & $name)
		_GUICtrlListViewDeleteItem($listview, $pos)
	EndIf
;	MainActivate()
EndFunc

Func EvtSort(ByRef $listview) ; sort Service/Device list by the column header clicked on
	$bSet = 0
	$nCurCol = $nCol
	GUICtrlSendMsg($listview, $LVM_SETSELECTEDCOLUMN, GUICtrlGetState($listview), 0)
	DllCall('user32.dll', 'int', 'InvalidateRect', 'hwnd', GUICtrlGetHandle($listview), 'int', 0, 'int', 1)
EndFunc

; ================
; Edit Options
; ================
Func EvtEditUpdate(ByRef $listview, $pos)
	Local $displName, $name, $lvItem

	$displName = _GUICtrlListViewGetItemText($listview, $pos, 0)
	$name = _GUICtrlListViewGetItemText($listview, $pos, 1)

	If (GUICtrlRead($guiEditGroupCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditDescrCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditDisplNameCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditStartCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditTypeCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditErrorCtrlCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditDependOnCB) == $GUI_CHECKED) OR (GUICtrlRead($guiEditPathCB) == $GUI_CHECKED) Then
		If MsgBox(36, $guiUpdateParameter, $guiWantToUpdateParameter & ': ' &  @LF &  @LF & $displName & ' ' & '(' & $name & ')') == 6 Then
			If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '----- Update -----' & @LF & 'Key: ' & $basekey & '\Services\' & $name & @LF)

			If GUICtrlRead($guiEditDisplNameCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"DisplayName":   [Old] = "' & RegRead($basekey & '\Services\' & $name, 'DisplayName') & '"  [New] = "' & GUICtrlRead($guiEditDisplName) & '"' & @LF)
				If StringReplace (GUICtrlRead($guiEditDisplName), ' ', '') == '' Then
					RegDelete($basekey & '\Services\' & $name, 'DisplayName')
				Else
					RegWrite($basekey & '\Services\' & $name, 'DisplayName', 'REG_SZ', GUICtrlRead($guiEditDisplName))
				EndIf
				_GUICtrlListViewSetItemText($listview, $pos, 0, RegRead($basekey & '\Services\' & $name, 'DisplayName'))
			EndIf
			If GUICtrlRead($guiEditPathCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"ImagePath":   [Old] = "' & _GUICtrlListViewGetItemText($listview, $pos, 6) & '"  [New] = "' & GUICtrlRead($guiEditPath) & '"'  & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 6, GUICtrlRead($guiEditPath))
				RegWrite($basekey & '\Services\' & $name, 'ImagePath', 'REG_EXPAND_SZ', GUICtrlRead($guiEditPath))
			EndIf
			If GUICtrlRead($guiEditDependOnCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"DependOnService":   [Old] = "' & _GUICtrlListViewGetItemText($listview, $pos, 9) & '"  [New] = "' & GUICtrlRead($guiEditDependOn) & '"'  & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 9, GUICtrlRead($guiEditDependOn))
				If StringReplace (GUICtrlRead($guiEditDependOn), ' ', '') == '' Then
					RegDelete($basekey & '\Services\' & $name, 'DependOnService')
				Else
					RegWrite($basekey & '\Services\' & $name, 'DependOnService', 'REG_MULTI_SZ', StringReplace(StringReplace(GUICtrlRead($guiEditDependOn), ',', @LF), ' ', ''))
				EndIf
			EndIf
			If GUICtrlRead($guiEditDescrCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"Description":   [Old] = "' & _GUICtrlListViewGetItemText($listview, $pos, 4) & '"  [New] = "' & GUICtrlRead($guiEditDescr) & '"' & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 4, GUICtrlRead($guiEditDescr))
				If StringReplace (GUICtrlRead($guiEditDescr), ' ', '') == '' Then
					RegDelete($basekey & '\Services\' & $name, 'Description')
				Else
					RegWrite($basekey & '\Services\' & $name, 'Description', 'REG_SZ', GUICtrlRead($guiEditDescr))
				EndIf
			EndIf
			If GUICtrlRead($guiEditStartCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"Start":   [Old] = "' & RegRead($basekey & '\Services\' & $name, 'Start') & '"  [New] = "' & _GUICtrlComboGetCurSel($guiEditStart) & '"' & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 2, GUICtrlRead($guiEditStart))
				RegWrite($basekey & '\Services\' & $name, 'Start', 'REG_DWORD', _GUICtrlComboGetCurSel($guiEditStart))
			EndIf
			If GUICtrlRead($guiEditTypeCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"Type":   [Old] = "' & RegRead($basekey & '\Services\' & $name, 'Type') & '"  [New] = "' & $type[0][_GUICtrlComboGetCurSel($guiEditType)] & '"'  & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 3, GUICtrlRead($guiEditType))
				RegWrite($basekey & '\Services\' & $name, 'Type', 'REG_DWORD', $type[0][_GUICtrlComboGetCurSel($guiEditType)])
			EndIf
			If GUICtrlRead($guiEditErrorCtrlCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"ErrorControl":   [Old] = "' & RegRead($basekey & '\Services\' & $name, 'ErrorControl') & '"  [New] = "' & _GUICtrlComboGetCurSel($guiEditErrorCtrl) & '"'  & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 8, GUICtrlRead($guiEditErrorCtrl))
				RegWrite($basekey & '\Services\' & $name, 'ErrorControl', 'REG_DWORD', _GUICtrlComboGetCurSel($guiEditErrorCtrl))
			EndIf
			If GUICtrlRead($guiEditGroupCB) == $GUI_CHECKED Then
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '"Group":   [Old] = "' & _GUICtrlListViewGetItemText($listview, $pos, 5) & '"  [New] = "' & GUICtrlRead($guiEditGroup) & '"' & @LF)
				_GUICtrlListViewSetItemText($listview, $pos, 5, GUICtrlRead($guiEditGroup))
				If GUICtrlRead($guiEditGroup) == ' ' Then
					RegDelete($basekey & '\Services\' & $name, 'Group')
				Else
					RegWrite($basekey & '\Services\' & $name, 'Group', 'REG_SZ', GUICtrlRead($guiEditGroup))
				EndIf
			EndIf
			If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then FileWrite($logFileDir & $logFile, '--- Update End ---' & @LF & @LF)
			
			;If srv changes to dev or vice versa
			If ($listview == $lvServiceList) AND (StringInStr($type[1][0] & $type[1][1] & $type[1][2] & $type[1][3], GUICtrlRead($guiEditType)) <> 0) Then
				_GUICtrlListViewSetItemText($listview, $pos, 7, '')
				_GUICtrlListViewSwitchItem($listview, $pos, $lvDeviceList)
				_GUICtrlListViewDeleteItem($listview, $pos)
				RegDelete($basekey & '\Services\' & $name, 'ObjectName')
			EndIf

			If ($listview == $lvDeviceList) AND (StringInStr($type[1][4] & $type[1][5] & $type[1][6] & $type[1][7], GUICtrlRead($guiEditType)) <> 0) Then
				_GUICtrlListViewSetItemText($listview, $pos, 7, 'LocalSystem')
				_GUICtrlListViewSwitchItem($listview, $pos, $lvServiceList)
				_GUICtrlListViewDeleteItem($listview, $pos)
				RegWrite($basekey & '\Services\' & $name, 'ObjectName', 'REG_SZ', 'LocalSystem')
			EndIf
			Return 1
		EndIf
	EndIf
	Return 0
EndFunc

Func _GUICtrlListViewSwitchItem(ByRef $lvBase, $index, ByRef $lvTarget, $titel)
	LOCAL $lvItem
	$lvItem = GUICtrlCreateListViewItem (' |||||||||', $lvTarget)
	GUICtrlSetData ($lvItem, _GUICtrlListViewGetItemText($lvBase, $index, -1, $titel))
EndFunc

Func EvtEditPath() ; Select path and file for Service
	GUICtrlSetState($guiEditPathBtn, $GUI_DISABLE)
	GUICtrlSetState($guiEditUpdateBtn, $GUI_DISABLE)
	GUICtrlSetState($guiEditCancelBtn, $GUI_DISABLE)

	LOCAL $file = FileOpenDialog( $guiSelectService, EnvGet('WinDir') & '\System32', 'Services (*.exe; *.dll; *.sys)')
	If @error Then
		MsgBox(8192 + 16,$guiError,$guiNoFileChosen)
	Else
		GUICtrlSetData ($guiEditPath, $file)
	EndIF

	GUICtrlSetState($guiEditPathBtn, $GUI_ENABLE)
	GUICtrlSetState($guiEditUpdateBtn, $GUI_ENABLE)
	GUICtrlSetState($guiEditCancelBtn, $GUI_ENABLE)
EndFunc

; ================
; New
; ================
Func EvtNewInstSrv()
	LOCAL $msg ='', $name = GUICtrlRead($guiNewName), $string = ''
	LOCAL $file, $displName, $lvItem

	If ($name <> '') AND (GUICtrlRead($guiNewPath) <> '') Then
		RegRead ($basekey & '\Services\' & GUICtrlRead($guiNewName), '')
		If @error == 1 Then
			If MsgBox (36, $guiInstallService, $guiWantToInstallService1 & ' "' & GUICtrlRead($guiNewPath) & '"' & @LF & $guiWantToInstallService2 & ': ' & GUICtrlRead($guiNewDisplName) & ' ' & '(' & $name & ')') == 6 Then
				; write to registry
				RegWrite($basekey & '\Services\' & $name)
				If GUICtrlRead($guiNewDisplName) <> '' Then RegWrite($basekey & '\Services\' & $name, 'DisplayName', 'REG_SZ',  GUICtrlRead($guiNewDisplName))
				RegWrite($basekey & '\Services\' & $name, 'ImagePath', 'REG_EXPAND_SZ', GUICtrlRead($guiNewPath))
				If GUICtrlRead($guiNewDependOn) <> '' Then RegWrite($basekey & '\Services\' & $name, 'DependOnService', 'REG_MULTI_SZ',  StringReplace(StringReplace(GUICtrlRead($guiNewDependOn), ',', @LF), ' ', ''))
				If GUICtrlRead($guiNewDescr) <> '' Then RegWrite($basekey & '\Services\' & $name, 'Description', 'REG_SZ',  GUICtrlRead($guiNewDescr))
				RegWrite($basekey & '\Services\' & $name, 'Start', 'REG_DWORD', _GUICtrlComboGetCurSel($guiNewStart))
				RegWrite($basekey & '\Services\' & $name, 'Type', 'REG_DWORD', $type[0][_GUICtrlComboGetCurSel($guiNewType)])
				RegWrite($basekey & '\Services\' & $name, 'ErrorControl', 'REG_DWORD', _GUICtrlComboGetCurSel($guiNewErrorCtrl))
				If GUICtrlRead($guiNewGroup) <> ' ' Then RegWrite($basekey & '\Services\' & $name, 'Group', 'REG_SZ',  GUICtrlRead($guiNewGroup))

				; update ListView

				If $type[2][_GUICtrlComboGetCurSel($guiNewType)] == 'Service' Then
						$lvItem = GUICtrlCreateListViewItem(' |||||||LocalSystem||', $lvServiceList)
;						GUICtrlSetData ($lvItem, RegRead($basekey & '\Services\' & $name, 'DisplayName') & '|' & $name & '|' & GUICtrlRead($guiNewStart) & '|' & GUICtrlRead($guiNewType) & '|' & GUICtrlRead($guiNewDescr) & '|' & GUICtrlRead($guiNewGroup) & '|' & GUICtrlRead($guiNewPath) & '|' & 'LocalSystem' & '|' & GUICtrlRead($guiNewErrorCtrl) & '|' & GUICtrlRead($guiNewDependOn))
						RegWrite($basekey & '\Services\' & $name, 'ObjectName', 'REG_SZ', 'LocalSystem')
				Else
						$lvItem = GUICtrlCreateListViewItem(' |||||||||', $lvDeviceList)
				EndIf
				GUICtrlSetData ($lvItem, RegRead($basekey & '\Services\' & $name, 'DisplayName') & '|' & $name & '|' & GUICtrlRead($guiNewStart) & '|' & GUICtrlRead($guiNewType) & '|' & GUICtrlRead($guiNewDescr) & '|' & GUICtrlRead($guiNewGroup) & '|' & GUICtrlRead($guiNewPath) & '|' & '' & '|' & GUICtrlRead($guiNewErrorCtrl) & '|' & GUICtrlRead($guiNewDependOn))
				; write to log file if selected
				If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then
					FileWrite($logFileDir & $logFile, '----- Install -----' & @LF & 'Key: ' & $basekey & '\Services\' & $name & @LF & @LF)
					RunWait ('reg.exe EXPORT ' & $basekey & '\Services\' & $name & ' ' & $logFileDir & 'ServicesPE.tmp', '' , @SW_HIDE)
					$file = FileOpen ($logFileDir & 'ServicesPE.tmp', 0)
					Do
						$string = $string & FileRead($file, 1)
					Until @error = -1
					FileClose($file)
					FileWrite($logFileDir & $logFile, $string)
					FileDelete($logFileDir & 'ServicesPE.tmp')
					FileWrite($logFileDir & $logFile, '--- Install End ---' & @LF & @LF)
				EndIf
				Return 1
			EndIf
		Else
			MsgBox(64, $guiError, $guiServiceExists1 & ': "' &  GUICtrlRead($guiNewName) & '" ' & $guiServiceExists2 & '.')
		EndIf
	Else
			If GUICtrlRead($guiNewName) == '' Then $msg = 'ServiceName ' & @LF
			If GUICtrlRead($guiNewPath) == '' Then $msg = $msg & 'Path ' & @LF
			MsgBox (64, $guiError, $guiFillOut & ':' & @LF & @LF & $msg)
	EndIf
	Return 0
EndFunc

Func EvtNewPath() ; Select path and file for Service
	LOCAL $file

	GUICtrlSetState($guiNewPathBtn, $GUI_DISABLE)
	GUICtrlSetState($guiNewInstallBtn, $GUI_DISABLE)
	GUICtrlSetState($guiNewCancelBtn, $GUI_DISABLE)

	$file = FileOpenDialog( $guiSelectService, EnvGet('WinDir') & '\System32', 'Services (*.exe; *.sys)')
	If @error Then
		MsgBox(8192 + 16, $guiError, $guiNoFileChosen)
	Else
		GUICtrlSetData ($guiNewPath, $file)
	EndIF

	GUICtrlSetState($guiNewPathBtn, $GUI_ENABLE)
	GUICtrlSetState($guiNewInstallBtn, $GUI_ENABLE)
	GUICtrlSetState($guiNewCancelBtn, $GUI_ENABLE)
EndFunc


; =========================
; Help text
; =========================
Func EvtHelp()
    LOCAL $message = $guiHelpDescription & @CRLF & @CRLF & $guiHelpProgrammer & @CRLF & @CRLF & 'Language: ' & $language & '  Translated by: ' & $author & @CRLF & @CRLF & 'SupportForum : http://www.911cd.net/forums//index.php?showtopic=12974'
	MsgBox(8192 + 32, $guiHelpTitle, $message)
EndFunc


; ================
; Log
; ================
Func EvtLogPath() ; Select Log file path
	GUICtrlSetState($guiLogPathBtn, $GUI_DISABLE)
	GUICtrlSetState($guiLogOkBtn, $GUI_DISABLE)
	GUICtrlSetState($guiLogCancelBtn, $GUI_DISABLE)

	LOCAL $folder = FileSelectFolder( $guiSelectLogfilePath, '', 4, $logFileDir)
	If @error Then
		MsgBox(8192 + 16,$guiError,$guiNoFolderChosen)
	Else
		If StringRight($folder,1) <> '\' Then $folder = $folder & '\'
		GUICtrlSetData ($guiLogPath, $folder & $logFile)
		$logFileDir = $folder
	EndIF

	GUICtrlSetState($guiLogPathBtn, $GUI_ENABLE)
	GUICtrlSetState($guiLogOkBtn, $GUI_ENABLE)
	GUICtrlSetState($guiLogCancelBtn, $GUI_ENABLE)
EndFunc

Func EvtLogOk()
	If GUICtrlRead($guiLogCB) == $GUI_CHECKED Then
		FileWrite($logFileDir & $logFile, '==========' & 'ServicesPE LogFile (' & @YEAR & '-' & @MON & '-' & @MDAY & '  ' & @HOUR & ':' & @MIN & ':' & @SEC & ')' & '==========' & @LF & @LF)
	EndIf
EndFunc

;***************************
;Helper
;***************************

Func UpdUnchk()
	GUICtrlSetState($guiEditDisplNameCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditPathCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditDependOnCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditDescrCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditStartCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditTypeCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditErrorCtrlCB, $GUI_UNCHECKED)
	GUICtrlSetState($guiEditGroupCB, $GUI_UNCHECKED)
EndFunc

; ==========================
; Activate Main Window
; ==========================
Func MainActivate() 
	GUISwitch($guiMain)
	WinActivate($guiTitel)
	GUISetState(@SW_SHOW, $guiMain)
	$lvVariableList = SetList ($lvVariableList)
	GUICtrlSetState($guiServicesBtn, $GUI_ENABLE)
	GUICtrlSetState($guiDevicesBtn, $GUI_ENABLE)
	GUICtrlSetState($guiNewBtn, $GUI_ENABLE)
	GUICtrlSetState($guiDelBtn, $GUI_ENABLE)
	GUICtrlSetState($guiEditBtn, $GUI_ENABLE)
	GUICtrlSetState($guiLogBtn, $GUI_ENABLE)
	GUICtrlSetState($guiLocalHiveBtn, $GUI_ENABLE)
	GUICtrlSetState($guiRunningOSHiveBtn, $GUI_ENABLE)
	GUICtrlSetState($guiRemoteHiveBtn, $GUI_ENABLE)
	GUICtrlSetState($guiHelpBtn, $GUI_ENABLE)
	GUICtrlSetState($guiExitBtn, $GUI_ENABLE)
EndFunc

; ==========================
; Deactivate Main Window
; ==========================
Func MainDeactivate() 
	GUICtrlSetState($lvDeviceList, $GUI_DISABLE)
	GUICtrlSetState($lvServiceList, $GUI_DISABLE)
	GUICtrlSetState($guiServicesBtn, $GUI_DISABLE)
	GUICtrlSetState($guiDevicesBtn, $GUI_DISABLE)
	GUICtrlSetState($guiNewBtn, $GUI_DISABLE)
	GUICtrlSetState($guiDelBtn, $GUI_DISABLE)
	GUICtrlSetState($guiEditBtn, $GUI_DISABLE)
	GUICtrlSetState($guiLogBtn, $GUI_DISABLE)
	GUICtrlSetState($guiLocalHiveBtn, $GUI_DISABLE)
	GUICtrlSetState($guiRunningOSHiveBtn, $GUI_DISABLE)
	GUICtrlSetState($guiRemoteHiveBtn, $GUI_DISABLE)
	GUICtrlSetState($guiHelpBtn, $GUI_DISABLE)
	GUICtrlSetState($guiExitBtn, $GUI_DISABLE)
EndFunc

; ==========================
; Set Services or Devices
; ==========================
Func SetList(ByRef $listview)
	If $listview == $lvServiceList Then
			GUICtrlSetState ($lvServiceList, $GUI_SHOW + $GUI_ENABLE)
			GUICtrlSetState ($lvDeviceList, $GUI_HIDE + $GUI_DISABLE)
			GUICtrlSetState ($guiMenuITService,$GUI_CHECKED)
			GUICtrlSetState ($guiMenuITDevice,$GUI_UNCHECKED)
			Return $lvServiceList
	Else
			GUICtrlSetState ($lvServiceList, $GUI_HIDE + $GUI_DISABLE)
			GUICtrlSetState ($lvDeviceList, $GUI_SHOW + $GUI_ENABLE)
			GUICtrlSetState ($guiMenuITService,$GUI_UNCHECKED)
			GUICtrlSetState ($guiMenuITDevice,$GUI_CHECKED)
			Return $lvDeviceList
	EndIf
EndFunc

; =========================
; SortFunc by Holger
; =========================
Func LVSort($hWnd, $nItem1, $nItem2, $nColumn)
    Local $nSort, $val1, $val2, $nResult
    
  ; Switch the sorting direction
    If $nColumn = $nCurCol Then
        If Not $bSet Then
            $nSortDir = $nSortDir * -1
            $bSet = 1
        EndIf
    Else
        $nSortDir = 1
    EndIf
    $nCol = $nColumn
        
    $val1   = GetSubItemText($hWnd, $nItem1, $nColumn)
    $val2   = GetSubItemText($hWnd, $nItem2, $nColumn)
    
    $nResult = 0      ; No change of item1 and item2 positions
    
    If $val1 < $val2 Then
        $nResult = -1 ; Put item2 before item1
    ElseIf  $val1 > $val2 Then
        $nResult = 1  ; Put item2 behind item1
    EndIf

    $nResult = $nResult * $nSortDir
    
    Return $nResult
EndFunc

Func GetSubItemText($nCtrlID, $nItemID, $nColumn)
    Local $stLvfi       = DllStructCreate('uint;ptr;int;int[2];int')
    DllStructSetData($stLvfi, 1, $LVFI_PARAM)
    DllStructSetData($stLvfi, 3, $nItemID)

    Local $stBuffer     = DllStructCreate('char[260]')
    
  
    Local $nIndex = GUICtrlSendMsg($nCtrlID, $LVM_FINDITEM, -1, DllStructGetPtr($stLvfi))
    
    Local $stLvi        = DllStructCreate('uint;int;int;uint;uint;ptr;int;int;int;int')
    
    DllStructSetData($stLvi, 1, $LVIF_TEXT)
    DllStructSetData($stLvi, 2, $nIndex)
    DllStructSetData($stLvi, 3, $nColumn)
    DllStructSetData($stLvi, 6, DllStructGetPtr($stBuffer))
    DllStructSetData($stLvi, 7, 260)

    GUICtrlSendMsg($nCtrlID, $LVM_GETITEMA, 0, DllStructGetPtr($stLvi));

    Local $sItemText  = DllStructGetData($stBuffer, 1)

    Return $sItemText
EndFunc

; =========================
; Exit Program
; =========================
Func OnAutoItExit()
	GUIDelete()
	UnloadHive()
	TCPShutdown()		
EndFunc


; **********************************
; AutoIt Functions
; **********************************

;===============================================================================
;
; Description:			_GUICtrlComboSelectString
; Parameter(s):		$h_combobox - controlID
;							$i_index - Specifies the zero-based index of the item preceding the first item to be searched
;							$s_search - String that contains the characters for which to search
; Requirement:			None
; Return Value(s):	If the string is found, the return value is the index of the selected item.
;							If the search is unsuccessful, the return value is $CB_ERR and the current selection is not changed
; User CallTip:		_GUICtrlComboSelectString($h_combobox, $i_index, $s_search) Search the list of a combo box for an item that begins with the characters in a specified string (required: <GuiCombo.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				When the search reaches the bottom of the list, it continues from the top
;							of the list back to the item specified by the wParam parameter.
;							If $i_index is 1, the entire list is searched from the beginning
;							A string is selected only if the characters from the starting point
;							match the characters in the prefix string
;
;===============================================================================
Func _GUICtrlComboSelectString($h_combobox, $i_index, $s_search)
	If IsHWnd($h_combobox) Then
		Local $a_ret = DllCall("user32.dll", "int", "SendMessage", "hwnd", $h_combobox, "int", $CB_SELECTSTRING, "int", $i_index, "str", $s_search)
		Return $a_ret[0]
	Else
		Return GUICtrlSendMsg($h_combobox, $CB_SELECTSTRING, $i_index, $s_search)
	EndIf
EndFunc   ;==>_GUICtrlComboSelectString

;===============================================================================
;
; Description:			_GUICtrlComboSetCurSel
; Parameter(s):		$h_combobox - controlID
;							$i_index - Specifies the zero-based index of the string to select
; Requirement:			None
; Return Value(s):	If the message is successful, the return value is the index of the item selected.
;							If $i_index is greater than the number of items in the list or if $i_index is 1,
;							the return value is $CB_ERR and the selection is cleared
; User CallTip:		_GUICtrlComboSetCurSel($h_combobox, $i_index) Select a string in the list of a combo box (required: <GuiCombo.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				If this $i_index is 1, any current selection in the list is removed and the edit control is cleared
;
;===============================================================================
Func _GUICtrlComboSetCurSel($h_combobox, $i_index)
	If IsHWnd($h_combobox) Then
		Local $a_ret = DllCall("user32.dll", "int", "SendMessage", "hwnd", $h_combobox, "int", $CB_SETCURSEL, "int", $i_index, "int", 0)
		Return $a_ret[0]
	Else
		Return GUICtrlSendMsg($h_combobox, $CB_SETCURSEL, $i_index, 0)
	EndIf
EndFunc   ;==>_GUICtrlComboSetCurSel

;===============================================================================
;
; Description:			_GUICtrlComboGetCurSel
; Parameter(s):		$h_combobox - controlID
; Requirement:			None
; Return Value(s):	The return value is the zero-based index of the currently selected item.
;							If no item is selected, it is $CB_ERR
; User CallTip:		_GUICtrlComboGetCurSel($h_combobox) Retrieve the index of the currently selected item, if any, in the list box of a combo box (required: <GuiCombo.au3>)
; Author(s):			Gary Frost (custompcs at charter dot net)
; Note(s):				:
;
;===============================================================================
Func _GUICtrlComboGetCurSel($h_combobox)
	If IsHWnd($h_combobox) Then
		Local $a_ret = DllCall("user32.dll", "int", "SendMessage", "hwnd", $h_combobox, "int", $CB_GETCURSEL, "int", 0, "int", 0)
		Return $a_ret[0]
	Else
		Return GUICtrlSendMsg($h_combobox, $CB_GETCURSEL, 0, 0)
	EndIf
EndFunc   ;==>_GUICtrlComboGetCurSel

;===============================================================================
; Reduce Memory Function
; by ewieldra
;===============================================================================
Func _ReduceMemory($i_PID = -1)
    If $i_PID <> -1 Then
        Local $ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
        Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', $ai_Handle[0])
        DllCall('kernel32.dll', 'int', 'CloseHandle', 'int', $ai_Handle[0])
    Else
        Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
    EndIf

    Return $ai_Return[0]
EndFunc  ;==>_ReduceMemory
