
var mousezoomWheelLock = false;
var mousezoomInc = 10;
var mousezoomImgZoom = false;
var mousezoomInvertWheel = false;
var preZoom = 0;
var postZoom = 0;
var mousezoomFontSize = 72;


function mousezoomLoadPrefs()
{
  var prefObj = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
  var Branch = prefObj.getBranch("extensions.mousezoom.");

  mousezoomInc = Branch.getCharPref("mousezoomInc");
  mousezoomImgZoom = Branch.getBoolPref("mousezoomImgZoom");
  mousezoomInvertWheel = Branch.getBoolPref("mousezoomInvertWheel");

  if (mousezoomInc == false)
  {
    mousezoomInc = 10;
  }
  else
  {
    mousezoomInc = parseInt(mousezoomInc);
  }
}


function mousezoomInit()
{
  window.addEventListener("popupshowing", blockContextMenu, false);
  window.addEventListener("mousedown", mousezoomLockWheel, false);
	window.addEventListener("mouseup", mousezoomUnlockWheel, false);
  window.addEventListener("DOMMouseScroll", mousezoomWheelActivated, false);
}

function blockContextMenu(aEvent)
{
  if (preZoom != postZoom)
  {
    aEvent.preventDefault();
    aEvent.stopPropagation();
    return false;
  }
}

function mousezoomLockWheel(aEvent)
{
  preZoom = getCurZoomVal();

  // Reset Zoom
  if ((mousezoomWheelLock == true) && (aEvent.button == 0))
  {
    ZoomManager.prototype.getInstance().reset();
    if (mousezoomImgZoom == true)
    {
      mousezoomResetPicureZoom();
    }
    showZoomFactor();
    return;
  }

  // Lock wheel
  if ((mousezoomWheelLock == false) && (aEvent.button == 2))
  {
    mousezoomWheelLock = true;
    return;
  }
}

function mousezoomUnlockWheel(aEvent)
{
  postZoom = getCurZoomVal();
  mousezoomWheelLock = false;
  hideZoomFactor();
}

function mousezoomResetPicureZoom()
{
  var doc = getDocumentElement();
  var imgs = doc.getElementsByTagName('img');

  for (i = 0; i < imgs.length; i++)
  {
    imgs[i].style.width = '';
    imgs[i].style.height = '';
  }
}

function getCurZoomVal()
{
  return ZoomManager.prototype.getInstance().textZoom / 100;
}

function mousezoomZoomPictures()
{
  var curZoomVal = getCurZoomVal();
  var doc = getDocumentElement();
  var imgs = doc.getElementsByTagName('img');

  for (i = 0; i < imgs.length; i++)
  {
    var w = imgs[i].offsetWidth;
    var h = imgs[i].offsetHeight;

    imgs[i].style.width = parseInt(w * curZoomVal) + 'px';
    imgs[i].style.height = parseInt(h * curZoomVal) + 'px';
  }
}


function mousezoomWheelActivated(aEvent)
{
  var curZoomVal = 0;
  var zoomDirection = 0;

  mousezoomLoadPrefs();

  if (mousezoomWheelLock)
  {
    curZoomVal = ZoomManager.prototype.getInstance().textZoom;
    zoomDirection = aEvent.detail;
    if (mousezoomInvertWheel == true) zoomDirection = zoomDirection * -1;

    if (zoomDirection > 0)
    { // Zoom In
      if ((curZoomVal + mousezoomInc) < ZoomManager.prototype.getInstance().MAX)
      {
        ZoomManager.prototype.getInstance().textZoom = curZoomVal + mousezoomInc;
      }
    }
    else
    { // Zoom Out
      if ((curZoomVal - mousezoomInc) > ZoomManager.prototype.getInstance().MIN)
      {
        ZoomManager.prototype.getInstance().textZoom = curZoomVal - mousezoomInc;
      }
    }

    if (mousezoomImgZoom == true)
    {
      mousezoomResetPicureZoom();
      mousezoomZoomPictures();
    }

    showZoomFactor();
  }
}

function getDocumentElement()
{
  var doc = window.content.document;
  return doc;
}

function showZoomFactor()
{
  var zoomVal = ZoomManager.prototype.getInstance().textZoom;
  var doc = getDocumentElement();
  var body = doc.getElementsByTagName('body')[0];

  var el = doc.getElementById('zoomBox');
  if (el != null)
  {
    body.removeChild(el);
  }

  var el = doc.createElement('div');

  el.id = 'zoomBox';
  el.style.fontFamily = '"Verdana", sans-serif;';
  el.style.fontSize = (1 / (zoomVal / 100)) * mousezoomFontSize + 'px';
  el.style.position = 'fixed';
  el.style.textAlign = 'center';
  el.style.left = '0px';
  el.style.width = '100%';
  el.style.top = '45%';
  el.style.zIndex = '999';
  el.style.fontWeight = 'bolder';
  el.style.color = 'blue';
  el.style.opacity = '.5';

  var zoomText = document.createTextNode(zoomVal + "%");
  el.appendChild(zoomText);

  body.appendChild(el);
}

function hideZoomFactor()
{
  var doc = getDocumentElement();
  var body = doc.getElementsByTagName('body')[0];

  var el = doc.getElementById('zoomBox');
  if (el != null)
  {
    body.removeChild(el);
  }
}
