var gConverterPrefs =
{
  // Describes the schema
  pref_list:{
    'pref_24h':'boolean',
    'pref_fullpage_icon':'boolean',
    'pref_fullpage_menu':'boolean',
    'pref_selection_menu':'boolean',
    'pref_metric':'boolean',
    'pref_in_fract':'boolean'
  },
  
  // Describes the defaults
  pref_defaults:{
    'pref_24h':true,
    'pref_fullpage_icon':true,
    'pref_fullpage_menu':true,
    'pref_selection_menu':true,
    'pref_metric':true,
    'pref_in_fract':true
  },
  
  // Contains the cached prefs
  prefs:{
  },

  // Have we cached the prefs?
  prefs_cached:false,
  
  // Our very own nsIPrefBranch object; it gets destroyed after each operation
  pO:false,
  
  // public; direct use encouraged
  getPref:function(pref)
  {
    this.buildCache();
    return this.prefs[pref];
  },
  
  // public; direct use encouraged
  setPref:function(pref,val)
  {
    this.ensurePo();
    if (!this._writePref(pref,val)) {
      return false;
    }
    this.prefs[pref]=val;
    return true;
  },
  
  // public; direct use discouraged
  buildCache:function()
  {
    if (this.prefs_cached) {
      return true;
    }
    this.ensurePo();
    var prefs=this.pO;
    for(var pref in this.pref_list) {
      if (prefs.getPrefType(pref)==prefs.PREF_INVALID) {
        this.setPref(pref,this.pref_defaults[pref]);
      }
      this.prefs[pref]=this._readPref(pref);
    }
    return true;
  },
  
  // public; direct use discouraged
  clearCache:function()
  {
    this.prefs_cached=false;
  },

  // public; direct use discouraged
  ensurePo:function()
  {
    if (!this.pO) {
      var prefs = Components.classes["@mozilla.org/preferences-service;1"].
                  getService(Components.interfaces.nsIPrefService);
      prefs = prefs.getBranch("extensions.converter.preferences.");
      this.pO=prefs;
    }
    return this.pO;
  },
  
  // public; direct use discouraged
  clearPo:function()
  {
    if (this.pO) {
      this.pO=null;
    }
    return true;
  },
  
  // private
  _readPref:function(pref)
  {
    if(this.pref_list[pref]=='boolean') {
      return this.pO.getBoolPref(pref);
    }
    // to be extended
    return null;
  },
  
  // private
  _writePref:function(pref,val)
  {
    // Too lazy to check whether Moz prefs match exactly on JS types, so
    // I'll check manually for now.
    if(this.pref_list[pref]=='boolean') {
      if(typeof(val)!='boolean') {
        return false;
      }
      this.pO.setBoolPref(pref,val);
      return true;
    }
    // to be extended
    return null;
  }
}
