var gConverterTZ =
{
  timezones : {
    "IDLW":-12,
    "NT":-11,
    "HST":-10,
    "AKST":-9,
    "PST":-8,"AKDT":-8,
    "MST":-7,"PDT":-7,
    "CST":-6,"MDT":-6,
    "EST":-5,"CDT":-5,
    "EDT":-4,"AST":-4,
    "GUY":-3,"ADT":-3,
    "AT":-2,
    "UTC":0,"GMT":0,"Z":0,"WET":0,
    "WEST":1,"CET":1,"BST":1,"IST":1,
    "CEST":2,"EET":2,
    "EEST":3,"MSK":3,
    "MSD":4,"ZP4":4,
    "ZP5":5,
    "ZP6":6,
    "WAST":7,
    "AWST":8,"WST":8,
    "JST":9,
    "ACST":9.5,
    "ACDT":10.5,
    "AEST":10,
    "AEDT":11,
    "NZST":12,"IDLE":12,
    "NZDT":13
  },
  
  // returns an offset in hours
  get_local_offset:function()
  {
    var D=new Date();
    return -D.getTimezoneOffset()/60;
  },
  
  // tz is a timezone of the form +/-xxxx or DST, CET, GMT, etc
  // returns an offset in hours
  get_tz_offset:function(tz)
  {
    // Is it +xxxx or -xxxx?
    var re = /^([+-])([0-9]{2})([0-9]{2})$/;
    var ree=re.exec(tz);
    if (ree && ree[0]) {
      var sgn=ree[1];
      var h=new String(ree[2]);
      var m=new String(ree[3]);
      if (h.substr(0,0)=='0') {
        h=h.substr(1);
      }
      return eval(sgn+'1*('+h+'+'+m+'/60)');
    }
    
    // Yes, we do return an NaN on purpose
    return this.timezones[tz];
  }
}

